/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.resource;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import dev.toma.gunsrpg.GunsRPG;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import net.minecraft.client.resources.ReloadListener;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public abstract class SingleJsonFileReloadListener
extends ReloadListener<JsonElement> {
    private static final Marker MARKER = MarkerManager.getMarker((String)"ResourceLoader");
    private final ResourceLocation path;
    private final Gson gson;

    public SingleJsonFileReloadListener(ResourceLocation path, Gson gson) {
        this.path = path;
        this.gson = gson;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected JsonElement prepare(IResourceManager resourceManager, IProfiler profiler) {
        try (IResource resource = resourceManager.func_199002_a(this.path);
             InputStream stream = resource.func_199027_b();
             BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));){
            JsonElement element = (JsonElement)JSONUtils.func_193839_a((Gson)this.gson, (Reader)reader, JsonElement.class);
            if (element != null) {
                JsonElement jsonElement = element;
                return jsonElement;
            }
            GunsRPG.log.error(MARKER, "Couldn't load data file {} as it's null or doesn't exist.", (Object)this.path);
            return new JsonObject();
        }
        catch (JsonParseException | IOException | IllegalArgumentException e) {
            GunsRPG.log.error(MARKER, "Couldn't parse data file {} because {} exception was thrown.", (Object)this.path, (Object)e);
        }
        return new JsonObject();
    }
}

